```
# Volume 2 Theory Spec: 1D Tick‑Chain Double‑Flip Monte Carlo

This document defines the toy‑model pipeline and operators used in the Monte Carlo simulation.

---

## State Space

The system lives on a one‑dimensional integer lattice of “context layers”:
```

r ∈ { -N, -N+1, …, -1, 0, 1, …, N-1, N }

```
Here, `N` is the maximum layer index (default N = 5).

---

## Operators

- **Renewal (F)**  
  Shifts one step outward:  
```

F(r) = max(r - 1, -N)

```

- **Sink (S)**  
Shifts one step inward:  
```

S(r) = min(r + 1, +N)

```

- **Boundary Projector (B)**  
Collapses any state back to the “present” layer at r = 0:  
```

B(r) = 0    for all r

```

---

## Flip Sequences to Test

1. **Outward sequence**  
```

r\_out1  = F(r0)
r\_out2  = F(r\_out1)
r\_out2B = B(r\_out2)

```

2. **Inward sequence**  
```

r\_in1   = S(r0)
r\_in2   = S(r\_in1)
r\_in2B  = B(r\_in2)

```

where `r0` is an initial sample uniformly drawn from the state space.

---

## Monte Carlo Goal

- Draw many independent samples of `r0` uniformly from –N to +N.  
- Apply both the outward and inward flip sequences.  
- Confirm that, for every trial, the final collapsed state (`r_out2B` and `r_in2B`) is always 0.  
- Record intermediate values (`r_out1`, `r_out2`, `r_in1`, `r_in2`) for histogram plotting and verification.
```
